/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.terraforged.engine.util.fastpoisson.FastPoisson;
import com.terraforged.engine.util.fastpoisson.FastPoissonContext;
import com.terraforged.mod.api.feature.decorator.DecorationContext;
import com.terraforged.mod.feature.decorator.ContextualDecorator;
import com.terraforged.mod.feature.decorator.poisson.DensityNoise;
import com.terraforged.mod.feature.decorator.poisson.FastPoissonConfig;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;

public abstract class FastPoissonDecorator
extends ContextualDecorator<FastPoissonConfig> {
    private static final int SEED_OFFSET = 234523;

    public FastPoissonDecorator() {
        super(FastPoissonConfig.CODEC);
    }

    @Override
    protected Stream<BlockPos> getPositions(WorldDecoratingHelper helper, DecorationContext context, Random random, FastPoissonConfig config, BlockPos pos) {
        IChunk chunk = context.getChunk();
        int seed = context.getGenerator().getContext().seed.root() + 234523;
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        FastPoisson poisson = FastPoisson.LOCAL_POISSON.get();
        try (DensityNoise density = config.getDensityNoise(seed, context);){
            FastPoissonContext poissonConfig = new FastPoissonContext(config.radius, config.jitter, config.scale, density);
            Stream.Builder builder = Stream.builder();
            poisson.visit(seed, chunkX, chunkZ, random, poissonConfig, builder, this.getVisitor(context));
            Stream<BlockPos> stream = builder.build();
            return stream;
        }
    }

    protected abstract FastPoisson.Visitor<Consumer<BlockPos>> getVisitor(DecorationContext var1);
}

